/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.test;

import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWSession;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.Naming;
import simulator.ISimulator;
import simulator.scenario.BasicScenario;
import simulator.util.Properties;

public class SimTool {
    public void run(String[] theArgs) throws Exception {
        VWCommandLineArgs args = new VWCommandLineArgs(theArgs);
        String inputFile = args.getParameter("inputfile");
        if (inputFile != null) {
            args = new VWCommandLineArgs(inputFile, false);
        }
        VWSession session = null;
        String userName = null;
        String password = null;
        String routerURL = null;
        String scenarioFile = null;
        String scenarioName = null;
        String runtimeFile = null;
        String simulatorHost = null;
        String simulatorPort = null;
        if (args.isPresent("?")) {
            this.displayUsage();
        }
        if (args.isPresent("s")) {
            scenarioFile = args.getParameter("s");
        } else {
            this.displayUsage();
        }
        if (args.isPresent("n")) {
            scenarioName = args.getParameter("n");
        }
        if (args.isPresent("r")) {
            runtimeFile = args.getParameter("r");
        }
        routerURL = args.isPresent("z") ? args.getParameter("z") : "localhost/vwrouter";
        userName = args.isPresent("u") ? args.getParameter("u") : "SysAdmin";
        simulatorHost = args.isPresent("host") ? args.getParameter("host") : "localhost";
        simulatorPort = args.isPresent("port") ? args.getParameter("port") : null;
        if (args.isPresent("p")) {
            password = args.getParameter("p");
            if (password.compareTo("\"\"") == 0) {
                password = "";
            }
        } else {
            password = "SysAdmin";
        }
        if (userName != null && !userName.equals("")) {
            this.print("Logging onto region.");
            session = new VWSession(userName, password, routerURL);
        }
        if (runtimeFile != null) {
            this.generateRuntimeXML(session, scenarioFile, runtimeFile);
        } else {
            this.runSimulation(session, scenarioFile, scenarioName, simulatorHost, simulatorPort);
        }
    }

    private void displayUsage() {
        System.out.println("************** RUN A SCENARIO **************");
        System.out.println("Usage: SimTool -s <scenarioFile> [-n <scenarioName>] -z <routerURL> -u <userName> -p <password> [-host <simulator-host>] [-port <simulator-port>]");
        System.out.println("  or /inputfile text_file_containing_params");
        System.out.println("\n************** GENERATE RUNTIME XML **************");
        System.out.println("Usage: SimTool -s <scenarioFile> -r <runtimeFile> -z <routerURL> -u <userName> -p <password>");
        System.out.println("  or /inputfile text_file_containing_params");
        System.exit(1);
    }

    private void runSimulation(VWSession session, String scenarioFile, String scenarioName, String host, String port) throws Exception {
        int status;
        VWScenarioValidationError[] errors;
        this.print("Loading scenario definition.");
        VWScenarioDefinition scenarioDef = VWScenarioDefinition.readFromFile(scenarioFile);
        if (session != null && (errors = scenarioDef.validate(session, true, true)) != null) {
            boolean validationError = false;
            for (int i = 0; i < errors.length; ++i) {
                if (errors[i].getErrorType() == 1) {
                    validationError = true;
                }
                this.print("\n" + errors[i].toString());
            }
            if (validationError) {
                System.exit(1);
            }
        }
        scenarioName = scenarioName != null && scenarioName.length() > 0 ? scenarioName : scenarioDef.getName();
        String serviceName = session != null ? session.getServerName() : "localhost";
        int isolatedRegion = session != null ? session.getIsolatedRegion() : 1;
        Properties props = Properties.getInstance();
        if (port == null) {
            port = props.getProperty("simulator.serviceport");
        }
        String name = "rmi://" + host + ":" + port + "/WorkflowSimulator";
        this.print("Connecting to simulation engine: " + name);
        ISimulator simServer = (ISimulator)Naming.lookup(name);
        this.print("Loading scenario XML.");
        StringBuffer xmlBuffer = new StringBuffer();
        if (session != null) {
            this.print("Generating runtime XML.");
            scenarioDef.toRuntimeXML(session, xmlBuffer);
        } else {
            this.print("Assuming scenario is already in runtime form.");
            scenarioDef.toXML(xmlBuffer);
        }
        this.print("Constructing new Scenario..");
        BasicScenario m_scenario = simServer.newScenario(serviceName, isolatedRegion, scenarioName, "SIMTOOL_TEST", xmlBuffer.toString(), null);
        this.print("Running scenario.");
        while ((status = simServer.getScenarioSchedulerStatus(m_scenario.id)) == 1) {
            Thread.sleep(5000L);
        }
        if (status == -1) {
            System.out.println("Error while running simulation.");
            System.exit(1);
        }
    }

    private void generateRuntimeXML(VWSession session, String scenarioFile, String runtimeFile) throws Exception {
        this.print("Loading scenario definition.");
        VWScenarioDefinition scenarioDef = VWScenarioDefinition.readFromFile(scenarioFile);
        VWScenarioValidationError[] errors = scenarioDef.validate(session, true, true);
        if (errors != null) {
            boolean validationError = false;
            for (int i = 0; i < errors.length; ++i) {
                if (errors[i].getErrorType() == 1) {
                    validationError = true;
                }
                this.print("\n" + errors[i].toString());
            }
            if (validationError) {
                System.exit(1);
            }
        }
        this.print("Generating runtime xml.");
        StringBuffer xmlBuffer = new StringBuffer();
        scenarioDef.toRuntimeXML(session, xmlBuffer);
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(runtimeFile);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)ostream, "UTF8");
            out.write(xmlBuffer.toString());
            ((Writer)out).flush();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception E) {}
            }
        }
    }

    private void print(String message) {
        System.out.println(message);
    }

    public static void main(String[] args) {
        try {
            SimTool simTool = new SimTool();
            simTool.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

